﻿using UnityEngine;
using UnityEngine.XR;

public class XRSetCameraHeight : MonoBehaviour
{
    public enum TrackingSpace
    {
        Stationary,
        RoomScale
    }

    public TrackingSpace trackingSpace = TrackingSpace.Stationary;
    public float stationaryCameraYOffset = 1.36144f;
    public GameObject cameraFloorOffsetObject;

    // Start is called before the first frame update
    void Awake()
    {

        if (enabled == false)
        {
            Destroy(this);
        }

        if (!cameraFloorOffsetObject)
        {
            Debug.LogWarning("No camera container specified for VR Rig, using attached GameObject");
            cameraFloorOffsetObject = this.gameObject;
        }

    }

    // Update is called once per frame
    void Start()
    {
        float cameraYOffset = stationaryCameraYOffset;
        if (trackingSpace == TrackingSpace.Stationary)
        {
            XRDevice.SetTrackingSpaceType(TrackingSpaceType.Stationary);
            InputTracking.Recenter();
            Debug.Log("Stationary");
        }
        else if (trackingSpace == TrackingSpace.RoomScale)
        {
            if (XRDevice.SetTrackingSpaceType(TrackingSpaceType.RoomScale))
                cameraYOffset = 0;
            Debug.Log("RoomScale");

        }

        //Move camera to correct height
        if (cameraFloorOffsetObject) 
            cameraFloorOffsetObject.transform.localPosition = new Vector3(cameraFloorOffsetObject.transform.localPosition.x, cameraYOffset, cameraFloorOffsetObject.transform.localPosition.z);
    }
}
;